<?php
// shop_template/api/add_sale_api.php
require_once __DIR__ . '/../config.php';
header('Content-Type: application/json');
$sales_table = $shop_prefix . 'sales';
$sale_items_table = $shop_prefix . 'sale_items';
$items = json_decode($_POST['items'] ?? '[]', true);
$subtotal = floatval($_POST['subtotal'] ?? 0);
$discount = floatval($_POST['discount'] ?? 0);
$discount_type = $_POST['discount_type'] ?? 'percent';
$vat = floatval($_POST['vat'] ?? 0);
$grand = floatval($_POST['grand_total'] ?? 0);
try {
    $pdo->beginTransaction();
    $stmt = $pdo->prepare("INSERT INTO `$sales_table` (customer_name, customer_email, customer_phone, customer_address, subtotal, discount, discount_type, vat, grand_total) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->execute(['Customer','','','',$subtotal,$discount,$discount_type,$vat,$grand]);
    $sale_id = $pdo->lastInsertId();
    $ins = $pdo->prepare("INSERT INTO `$sale_items_table` (sale_id, product_id, barcode, name, qty, price, total) VALUES (?, ?, ?, ?, ?, ?, ?)");
    foreach ($items as $it) {
        $ins->execute([$sale_id, $it['product_id'] ?? 0, $it['barcode'] ?? '', $it['name'] ?? '', $it['qty'] ?? 1, $it['price'] ?? 0, $it['total'] ?? 0]);
    }
    $pdo->commit();
    echo json_encode(['success'=>true,'sale_id'=>$sale_id]);
} catch (Exception $e) {
    $pdo->rollBack();
    echo json_encode(['success'=>false,'message'=>$e->getMessage()]);
}
?>